<?php
class Mas_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        $this->load->database();
        $this->load->model('mas_model');
    }

    // Función para obtener el mas basado en el ID
    public function obtenerMas($idmas)
    {
        $this->db->select('*')->from('mas')->where('id =', $idmas);

        $mas = $this->db->get()->row_array();

        $respuesta = array(
            'respuesta' => $mas,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }


    // Función para actualizar la imagen
    public function actualizarMas($mas)
    {   
        //Iniciando la transacción
        $this->db->trans_begin();
        $this->load->library('upload');
        
        $id       = $mas["id"];
        $img      = $mas["img"];
        $orden    = $mas["orden"];

        if(file_exists($_SERVER['DOCUMENT_ROOT'].'/assets/noticias/'.substr($mas['img'],39))){
            unlink($_SERVER['DOCUMENT_ROOT'].'/assets/noticias/'.substr($mas['img'],39));
        }
        
        $ruta = $_SERVER['DOCUMENT_ROOT'].'/assets/noticias/';
            if(array_key_exists('documento', $_FILES)){
                if (!is_dir($ruta)) {
                    mkdir($ruta, 0777, true);
                }
                $mi_archivo = 'documento';
                $config['upload_path'] = $_SERVER['DOCUMENT_ROOT'].'/assets/noticias/';
                $config['allowed_types'] = 'png|jpeg|gif|jpg';
                $config['encrypt_name'] = true;
                $config['max_size'] = '51200';
    
                $this->upload->initialize($config);
    
                if (!$this->upload->do_upload($mi_archivo)) {
                    //*** ocurrio un error
                    $data['uploadError'] = $this->upload->display_errors();
                    echo $this->upload->display_errors();
                    return;
                }else{

                // Creando el array con los datos básicos del usuario
                $mas = array(
                    'img'    => 'https://app.nld.gob.mx/assets/noticias/'.$this->upload->data('file_name'),
                );
                
                     // Actualizando la tabla de usuarios
                    $this->db->set($mas);
                    $this->db->where('id', $id);
                    $this->db->update('mas');
                }
                
                $data['uploadSuccess'] = $this->upload->data();
        }

        // Si la transacción presenta errores
        if($this->db->trans_status() === false)
        {
            $respuesta = array(
                'respuesta' => 'Ocurrio un error al actualizar los datos',
                'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
            );
    
            return $respuesta;
        }

        // De lo contrario
        else
        {
            $this->db->trans_commit();

            $respuesta = array(
                'respuesta' => 'Banner actualizado correctamente',
                'status' => REST_Controller::HTTP_OK
            );
    
            return $respuesta;
        }
    }

     // Función para eliminar la imagen
     public function eliminarMas($mas)
     {   
         //Iniciando la transacción
         $this->db->trans_begin();
         $this->load->library('upload');
         
         $id       = $mas["id"];
         $img      = $mas["img"];
         $orden    = $mas["orden"];
 
         if(file_exists($_SERVER['DOCUMENT_ROOT'].'/assets/noticias/'.substr($mas['img'],39))){
             unlink($_SERVER['DOCUMENT_ROOT'].'/assets/noticias/'.substr($mas['img'],39));
         }

            $this->db->where('id', $id);
            $this->db->delete('mas');
 
         // Si la transacción presenta errores
         if($this->db->trans_status() === false)
         {
             $respuesta = array(
                 'respuesta' => 'Ocurrio un error al actualizar los datos',
                 'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
             );
     
             return $respuesta;
         }
 
         // De lo contrario
         else
         {
             $this->db->trans_commit();
 
             $respuesta = array(
                 'respuesta' => 'Banner actualizado correctamente',
                 'status' => REST_Controller::HTTP_OK
             );
     
             return $respuesta;
         }
     }
    // Función para actualizar
    // public function actualizarMas($mas)
    // {
    //     $idmas = $mas["id"];
    //     $img      = $mas["img"];
    //     $orden    = $mas["orden"];

    //     // Creando el array con los datos básicos del usuario
    //     $mas = array(
    //         'id'     => $idmas,
    //         'img'    => $img,
    //         'orden'  => $orden,
    //     );

    //     //Iniciando la transacción
    //     $this->db->trans_begin();

    //     // Actualizando la tabla de usuarios
    //     $this->db->set($mas);
    //     $this->db->where('id', $idmas);
    //     $this->db->update('mas');

    //     // Si la transacción presenta errores
    //     if($this->db->trans_status() === false)
    //     {
    //         $respuesta = array(
    //             'respuesta' => 'Ocurrio un error al actualizar los datos',
    //             'status' => REST_Controller::HTTP_UNPROCESSABLE_ENTITY
    //         );
    
    //         return $respuesta;
    //     }

    //     // De lo contrario
    //     else
    //     {
    //         $this->db->trans_commit();

    //         $respuesta = array(
    //             'respuesta' => 'Información actualizada correctamente',
    //             'status' => REST_Controller::HTTP_OK
    //         );
    
    //         return $respuesta;
    //     }
    // }

    public function agregarMas($datos)
    {
        $this->load->library('upload');
        $this->db->trans_begin();
        
        $this->db->limit(1);
        $this->db->order_by('orden', 'DESC');
        $this->db->select('*')->from('mas');
        $orden = $this->db->get()->row_array();
            /////////FIRMA/////////////////
            $ruta = $_SERVER['DOCUMENT_ROOT'].'/assets/noticias/';
            if(array_key_exists('documento', $_FILES)){
                if (!is_dir($ruta)) {
                    mkdir($ruta, 0777, true);
                }
                $mi_archivo = 'documento';
                $config['upload_path'] = $_SERVER['DOCUMENT_ROOT'].'/assets/noticias/';
                $config['allowed_types'] = 'png|jpeg|gif|jpg';
                $config['encrypt_name'] = true;
                $config['max_size'] = '51200';
    
                $this->upload->initialize($config);
    
                if (!$this->upload->do_upload($mi_archivo)) {
                    //*** ocurrio un error
                    $data['uploadError'] = $this->upload->display_errors();
                    echo $this->upload->display_errors();
                    return;
                }else{
                // print_r($datos);
                // $id       = $dato["id"];
                // $orden    = $datos['orden'];

                // Creando el array con los datos básicos del usuario
                $mas = array(
                    'img'    => 'https://app.nld.gob.mx/assets/noticias/'.$this->upload->data('file_name'),
                    'orden'  => (int)$orden['orden'] + 1,
                );
                
                    $this->db->set($mas);
                    $this->db->insert('mas');
                }
                
                $data['uploadSuccess'] = $this->upload->data();
        }
        
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    //Función para cambiar el orden de las imágenes
     public function cambiar_orden($post){
        $this->db->trans_begin();
        $prevIndex = $post['prevIndex'];
        $currentIndex = $post['currentIndex'];

        $difference = $prevIndex['orden'] - $currentIndex['orden'];

        $current = $currentIndex['orden'];
        $prev = $prevIndex['orden'];


        if($difference > 1){
            $this->db->where('orden =', $prev);
            $this->db->set(array('orden' => 0));
            $this->db->update('mas');
            while($current < $prev){
                $this->db->where('orden =', $prev-1);
                // $this->db->where('id !=', $currentIndex['id']);
                $this->db->set(array('orden' => ($prev)));
                $this->db->update('mas');
                $prev--;
            }
            $this->db->where('orden =', 0);
            $this->db->set(array('orden' => $current));
            $this->db->update('mas');
            
        }else if($difference < -1){
            $this->db->where('orden =', $prev);
            $this->db->set(array('orden' => 0));
            $this->db->update('mas');
            while($current > $prev){
                $this->db->where('orden =', $prev+1);
                // $this->db->where('id !=', $currentIndex['id']);
                $this->db->set(array('orden' => ($prev)));
                $this->db->update('mas');
                $prev++;
            }
            $this->db->where('orden =', 0);
            $this->db->set(array('orden' => $current));
            $this->db->update('mas');
        }else{
            $this->db->where('id =', $prevIndex['id']);
            $this->db->set(array('orden' => $currentIndex['orden']));
            $this->db->update('mas');
            // print_r($this->db->last_query());
            $this->db->where('id =', $currentIndex['id']);
            $this->db->set(array('orden' => $prevIndex['orden']));
            $this->db->update('mas');
        }

        
        // print_r($this->db->last_query());
        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;
     }

    public function paginado($datos)
    {
        $this->load->library('paginado');
        $paginado = $this->paginado->paginar($datos, 'mas');
        
        $respuesta = array(
            'respuesta' => $paginado,
            'status' => REST_Controller::HTTP_OK
        );

        return $respuesta;
    }
}