<?php
class Categorias_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
        // Se agregar la conexion a la base de datos a toda la clase
        $this->load->database();
        $this->load->helper('paginacion');
    }

    public function paginado($datos)
    {
        $pagina = $datos['pagina'];
        $por_pagina = $datos['por_pagina'];
        $filtros = $datos['filtros'];
        $filtros = (array) $filtros;
        $order = $datos['order'];
        $campos = array('*');
        $respuesta = paginar_todo('categorias', $pagina, $por_pagina, $campos, $filtros, $order);
        $status = 200;
        return $respuesta;
    }

    public function consultar_categoria()
    {
        $idcategoria = $this->uri->segment(3);
        $query = $this->db->select('idcategoria, categoria, activo')->where('idcategoria', $idcategoria)->limit(1)->get('categorias');

        if ($query && $query->num_rows() >= 1) {
            $respuesta = array(
                'mensaje' => 'Registro cargado correctamente',
                'registro' => $query->row(),
                'status' => 200,
            );

        } else {
            $respuesta = array(
                'mensaje' => 'Error interno',
                'status' => 500,
            );

        }

        return $respuesta;
    }

    public function agregar_categoria($datos)
    {
        $categoria = $datos['categoria'];
        $activo = 1;

        $data = array(
            'categoria' => $categoria,
            'activo' => $activo,
        );

        $this->db->trans_begin();
        $insercion = $this->db->insert('categorias', $data);

        if ($this->db->trans_status() === false) {
            $this->db->trans_rollback();
            $respuesta = array(
                'mensaje' => 'Error en insercion.',
                'error' => $this->db->error(),
                'status' => 409,
            );

        } else {
            $this->db->trans_commit();
            $respuesta = array(
                'mensaje' => 'Inserción correcta',
                'status' => 200,
            );
        }
        return $respuesta;

    }

    public function actualizar_categoria($datos)
    {
        $idcategoria = $datos['idcategoria'];
        if (isset($idcategoria)) {
            $categoria = $datos['categoria'];

            $data = array(
                'categoria' => $categoria,
            );
            $this->db->trans_begin();
            $update = $this->db->set($data)->where('idcategoria', $idcategoria)->update('categorias');

            if ($this->db->trans_status() === false) {
                $this->db->trans_rollback();
                $respuesta = array(
                    'mensaje' => 'Error en actualización.',
                    'error' => $this->db->error(),
                    'status' => 409,
                );

            } else {
                $this->db->trans_commit();
                $respuesta = array(
                    'mensaje' => 'Actualización correcta',
                    'status' => 200,
                );
            }

        } else {
            $respuesta = array(
                'err' => true,
                'mensaje' => 'Error Interno',
                'status' => 500,
            );
        }
        return $respuesta;
    }

}
